﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using CgpibCs;
using CSubFuncCs;

namespace Sample
{
    class GPIB_CONTEC
    {
        // (0)Class variable
        private Cgpib Gpib = new Cgpib();
        private CSubFunc SubFunc = new CSubFunc();
        public uint MyAddress = 0;                                                     // My address
        private uint DeviceAddress = 0;                                                 // Device address
        public string MsgBuf = "";                                                      // Received Data
        private GCHandle gChCmd;                                                        // GCHandle for Cmd array

        // (1)Connect
        public bool OpenInterface(string primaryAddress)
        {
            uint mode;
            uint eoi;
            uint delim;
            string message;
            uint ret;

            ret = (uint)SubFunc.GpibInit(out message);                                  // Initialise GPIB
            if (ret != 0)
            {
                MessageBox.Show(message);
                return false;
            }

            ret = Gpib.Boardsts(0x0a, out mode);                                        // Read MASTER or SLAVE
            if (ret != 0)
            {
                SubFunc.CheckRet("GpBoardsts", ret, out message);                       // Check return value
                MessageBox.Show(message);
                return false;
            }
            if (mode != 0)
            {
                MessageBox.Show("This device is not MASTER. Please check your settings.");
                return false;
            }

            ret = Gpib.Boardsts(0x08, out MyAddress);                                   // Get my address
            if (ret != 0)
            {
                SubFunc.CheckRet("GpBoardsts", ret, out message);                       // Check return value
                MessageBox.Show(message);
                return false;
            }

            eoi = 1;                                                                    // 0:Not use / 1:Use
            delim = 3;                                                                  // 0:Unused / 1:CR+LF / 2:CR / 3:LF
            ret = Gpib.Delim(delim, eoi);                                               // Set delimiter code(EOI)
            if (ret != 0)
            {
                SubFunc.CheckRet("GpDelim", ret, out message);                          // Check return value
                MessageBox.Show(message);
                return false;
            }

            ret = Gpib.Timeout(10000);                                                  // Set timeout
            if (ret != 0)
            {
                SubFunc.CheckRet("GpTimeout", ret, out message);                        // Check return value
                MessageBox.Show(message);
                return false;
            }

            DeviceAddress = Convert.ToUInt32(primaryAddress);

            return true;
        }

        // (2)Disconnect
        public bool CloseInterface()
        {
            SubFunc.GpibExit(); 														// End of GPIB connection

            return true;

        }

        // (3)Send commands
        public bool SendMsg(string strMsg)
        {
            int ret;

            ret = SubFunc.GpibPrint(DeviceAddress, strMsg);                             // Write data in the transmit buffer
            if (ret != 0)
            {
                return false;
            }

            return true;
        }

        // (4)Receive
        public bool ReceiveMsg(uint timeout_ms)
        {
            string message;
            StringBuilder buf = new StringBuilder(8388608);
            uint ret;
            int ret2;

            ret = Gpib.Timeout(timeout_ms);
            if (ret != 0)
            {
                SubFunc.CheckRet("GpTimeout", ret, out message);                        // Check return value
                MessageBox.Show(message);
                return false;
            }

            ret2 = SubFunc.GpibInputHioki(DeviceAddress, buf);                           // Read data from the receive buffer
            if (ret2 != 0)
            {
                MsgBuf = "Error";
                return false;
            }
            MsgBuf = buf.ToString();                                                    // Save the data

            return true;

        }

        // (5)Transmit and receive commands
        public bool SendQueryMsg(string strMsg, uint timeout_ms)
        {
            bool ret = false;

            ret = SendMsg(strMsg);                                                      // Transmit commands
            if (ret)
            {
                if (strMsg.Contains("?"))
                {
                    ret = ReceiveMsg(timeout_ms);                                       // Receive response when command transmission is succeeded
                }
            }

            return ret;
        }
    }

}
